export default function Testimonials() {
  const testimonials = [
    {
      id: 1,
      name: 'Michael Rodriguez',
      location: 'San Antonio, TX',
      rating: 5,
      text: 'Nine Three Merch transformed my BMW M3 with their ceramic coating. The attention to detail is incredible!',
      service: 'Ceramic Coating',
      image: '/images/testimonials/customer1.jpg'
    },
    {
      id: 2,
      name: 'Sarah Johnson',
      location: 'Roxie, MS',
      rating: 5,
      text: 'Best detailing service I\'ve ever had. My interior looks brand new again. Highly recommend!',
      service: 'Interior Deep Clean',
      image: '/images/testimonials/customer2.jpg'
    },
    {
      id: 3,
      name: 'David Chen',
      location: 'San Antonio, TX',
      rating: 5,
      text: 'The monthly maintenance plan keeps my Tesla looking showroom fresh. Great value and service!',
      service: 'Monthly Maintenance',
      image: '/images/testimonials/customer3.jpg'
    }
  ]

  return (
    <section className="py-20 bg-gray-50">
      <div className="container">
        <div className="text-center mb-12">
          <h2 className="text-4xl md:text-5xl font-bold text-gray-900 mb-4">
            What Our Customers Say
          </h2>
          <p className="text-xl text-gray-600 max-w-2xl mx-auto">
            Don't just take our word for it - hear from our satisfied customers
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {testimonials.map((testimonial) => (
            <div key={testimonial.id} className="bg-white rounded-xl shadow-lg p-8 relative">
              {/* Quote Icon */}
              <div className="absolute top-4 right-4 text-6xl text-red-100">
                "
              </div>
              
              {/* Rating Stars */}
              <div className="flex mb-4">
                {[...Array(testimonial.rating)].map((_, i) => (
                  <svg
                    key={i}
                    className="w-5 h-5 text-yellow-400 fill-current"
                    viewBox="0 0 20 20"
                  >
                    <path d="M10 15l-5.878 3.09 1.123-6.545L.489 6.91l6.572-.955L10 0l2.939 5.955 6.572.955-4.756 4.635 1.123 6.545z" />
                  </svg>
                ))}
              </div>
              
              {/* Testimonial Text */}
              <p className="text-gray-700 mb-6 italic relative z-10">
                "{testimonial.text}"
              </p>
              
              {/* Service Badge */}
              <div className="mb-4">
                <span className="inline-block bg-red-100 text-red-800 text-xs px-3 py-1 rounded-full">
                  {testimonial.service}
                </span>
              </div>
              
              {/* Customer Info */}
              <div className="border-t pt-4">
                <p className="font-semibold text-gray-900">
                  {testimonial.name}
                </p>
                <p className="text-sm text-gray-600">
                  {testimonial.location}
                </p>
              </div>
            </div>
          ))}
        </div>

        <div className="text-center mt-12">
          <p className="text-gray-600 mb-4">
            Ready to experience our premium service?
          </p>
          <a href="/contact" className="btn-primary">
            Book Your Detail Today
          </a>
        </div>
      </div>
    </section>
  )
}
